(*| 14:20 13/06/1988 *)
PROGRAM WHATSNEW;

USES Crt,Printer,Dos;

CONST
  MaxDir=256;

TYPE
  FNameType= STRING[12];
  LineString= STRING[80];

VAR
  FindNewRec,FindOldRec: SearchRec;
  NewSpec,OldSpec,OptionString,OriginalPath,DestPath,TextLine: LineString;
  ListFileName: LineString;
  I,Level,NumOfFiles,FilesInThisDir: Integer;
  Abort,Print,SaveToFile,ShowDT: Boolean;
  C:Char;
  ListFile:TEXT;
  DirData: ARRAY[1..MaxDir] OF ^LineString;
  MemMark: Pointer;

FUNCTION IntToString(Num, Width : Integer) : LineString;
{ Changes an integer into a string }
VAR TempString : LineString;
BEGIN
  Str(Num:Width, TempString);
  IntToString := TempString;
END; { IntToString }

FUNCTION IntToPadString(Num, Width : Integer) : LineString;
{ Changes an integer into a string and pads it with a zero on the left if
  it is less than 10 }
BEGIN
  IF Num < 10 THEN
    IntToPadString := '0' + IntToString(Num, Width)
  ELSE
    IntToPadString := IntToString(Num, Width);
END; { IntToString }

FUNCTION RealToString(Num : Real; Width, Places : Integer) : LineString;
{ Changes a real number into a string }
VAR TempString : LineString;
BEGIN
  Str(Num:Width:Places, TempString);
  RealToString := TempString;
END; { RealToString }

{ ==================== GENERAL PURPOSE STRING ROUTINES ====================== }
FUNCTION FixString(FString : LineString; Len : Byte) : LineString;
{ Makes a string a specified length.  If the string is too long, the extra
  characters will be truncated.  If the string is too short, the string will
  be padded with spaces.
}
var StringLen : byte absolute FString;
                            { Make a variable for FString's length byte }
BEGIN
  IF StringLen > Len THEN
    Delete(FString, Succ(Len), StringLen - Len)
                                    { Delete end of string if it is too long }
  ELSE
    WHILE StringLen < Len DO          { Pad FString with spaces on the right }
      FString := FString + ' ';
  FixString := FString;
END; { FixString }

FUNCTION UpperCase(S : LineString) : LineString;
{ Convert a string to all upper case letters }
VAR I : integer;
BEGIN                               { Note that we intentionally modify a    }
  FOR I := 1 to LENGTH(S) DO        { VALUE parameter, and then return that  }
    S[I] := UpCase(S[I]);           { modified value via the function value. }
  UpperCase := S;
END; { UpperCase }

FUNCTION FileDateString(Date :DateTime):LineString;
BEGIN
  WITH Date DO
    FileDateString:=IntToString(Day,2) + '/' +
                    IntToPadString(Month,1) + '/' +
                    IntToString(Year,4);
END;  { FileDateString }

FUNCTION FileTimeString(Time :DateTime):LineString;
BEGIN
  WITH Time DO
    FileTimeString:=IntToString(Hour,2) + ':' +
                    IntToPadString(Min,1);
END; { FileTimeString }

PROCEDURE ShowHelp;
BEGIN
  Writeln('Usage    : WHATSNEW [D:][path][filespec] [ref D:][ref path] [/P][/D][/T]');
  Writeln('Switches : /P    Copy output to printer');
  Writeln('           /D    Copy output to disk, default filename WHATSNEW.TXT');
  Writeln('           /T    Show file date and time');
  HALT;
END;  { ShowHelp }

PROCEDURE ProcessOptions;
BEGIN
  Print:=False;
  ShowDT:=False;
  IF POS('/P',OptionString) > 0 THEN Print:=True;
  IF POS('/D',OptionString) > 0 THEN SaveToFile:=True;
  IF POS('/T',OptionString) > 0 THEN ShowDT:=True;
END; { ProcessOptions }

FUNCTION DosFault(FileName: LineString): Boolean;
VAR
  Result: Boolean;
BEGIN
  Result:=False;
  IF DosError > 0 THEN BEGIN
    Result:=True;
    Write(FileName,' ');
    Case DosError OF
      2:Writeln('File Not Found');
      3:Writeln('Path Not Found');
      ELSE Writeln('Dos Error ',DosError);
    END;
  END;
  DosFault:=Result;
END; { DosFault }

PROCEDURE ProcessThisFile(FileInfo:SearchRec);

VAR
  DT:DateTime;
  ChangeText,ThisFileText:LineString;

BEGIN
  ChangeText:='';
  WITH FileInfo DO BEGIN
    ThisFileText:=OldSpec + Name;
    FindFirst(ThisFileText,Archive,FindOldRec);
    IF (DosError = 2) OR (DosError = 18) THEN ChangeText:='New'
    ELSE BEGIN
      IF DosFault(ThisFileText) THEN
      ELSE BEGIN
       IF Time > FindOldRec.Time THEN ChangeText:='Later';
       IF Time < FindOldRec.Time THEN ChangeText:='Earlier';
       IF Length(ChangeText) > 0 THEN
         ChangeText:=ChangeText + ' than ' + OldSpec;
      END;
    END;
    ThisFileText:=FixString(Name,12) + ' ';
    IF ShowDT THEN BEGIN
      UnpackTime(Time,DT);
      ThisFileText:=ThisFileText + FileTimeString(DT) + ' '
                                 + FileDateString(DT) + ' ';
    END;
    IF Length(ChangeText) > 0 THEN BEGIN
      INC(NumOfFiles);
      ThisFileText:=ThisFileText + ' ' + ChangeText;
      Writeln(ThisFileText);
      IF Print THEN BEGIN
        Writeln(LST,ThisFileText);
      END;
      IF (SaveToFile) THEN BEGIN
        IF NumOfFiles > MaxDir THEN
          BEGIN
            Writeln('Too many files');
            Abort:=True;
          END
        ELSE BEGIN
          New(DirData[NumOfFiles]);
          DirData[NumOfFiles]^:=ThisFileText;
        END;
      END;
    END;
  END;
END; { ProcessThisFile }

FUNCTION AbortTest: Boolean;
VAR
  C:Char;
BEGIN
  IF KeyPressed THEN BEGIN
    C:=ReadKey;
    Writeln('Abort Y/N ? ');
    C:=ReadKey;
    IF UpCase(C) = 'Y' THEN Abort:=True;
    Writeln('Aborting');
  END;
  AbortTest:=Abort;
END; { AbortTest }

PROCEDURE ShowFiles;
BEGIN
  FilesInThisDir:=0;
  FindFirst(NewSpec,Archive,FindNewRec);
  IF DosFault(NewSpec) THEN HALT;
  WHILE DosError=0 DO BEGIN
    INC(FilesInThisDir);
    ProcessThisFile(FindNewRec);
    FindNext(FindNewRec);
    IF AbortTest THEN Exit;
  END;
END; { ShowFiles }

BEGIN
  Writeln('What Is New by B Whitnall, V1.0');
  OptionString:='';
  NewSpec:='*.*';
  OldSpec:='';
  SaveToFile:=False;
  ListFileName:='WHATSNEW.TXT';
  IF ParamCount > 0 THEN FOR I:=1 TO ParamCount DO BEGIN
    TextLine:=UpperCase(ParamStr(I));
    IF TextLine[1] = '/' THEN
      OptionString:=OptionString + TextLine
    ELSE BEGIN
      IF I = 1 THEN
        NewSpec:=TextLine;
      IF I = 2 THEN
        OldSpec:=TextLine;
      IF I = 3 THEN BEGIN
        ListFileName:=TextLine;
        SaveToFile:=True;
      END;
    END;
  END;
  IF NewSpec = '?' THEN ShowHelp;
  I:=POS(':',NewSpec);
  IF I > 0 THEN BEGIN
    IF Length(NewSpec) = I THEN
      NewSpec:=NewSpec+'*.*';
  END;
  I:=POS('.',NewSpec);
  IF I = 0 THEN
    BEGIN
      Writeln('Warning - No File Extension specified.');
      HALT;
    END;
  GetDir(0,OriginalPath);
  IF Length(OldSpec) = 0 THEN
   OldSpec:=OriginalPath;
  C:=OldSpec[Length(OldSpec)];
  IF NOT (C IN ['\',':']) THEN
    OldSpec:=OldSpec+ '\';
  ProcessOptions;
  NumOfFiles:=0;
  Abort:=False;
  Mark(MemMark);

  Writeln('Active Path : ',NewSpec,'   Reference path : ',OldSpec);
  Writeln;
  ShowFiles;

  Writeln(NumOfFiles:5,' files');
  ChDir(OriginalPath);
  IF SaveToFile THEN BEGIN
    Assign(ListFile,ListFileName);
    Rewrite(ListFile);
    Writeln('Saving Data To ',ListFileName);
    FOR I:=1 TO NumOfFiles DO
      Writeln(ListFile,DirData[I]^);
    Close(ListFile);
  END;
  Release(MemMark);
END.
